var base_url = $(".base_url").attr("id");

// Mask form 
$.getScript('https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js').done(() => {
  $('.mask-cpf').mask('000.000.000-00');
  $('.mask-date').mask('00/00/0000');
  $('.mask-phone').mask('(00) 00000-0000');
});

// View/hide password
$("#eye-show-login").click(function() {
    $("#senha").attr("type", "text");
});
$("#eye-hide-login").click(function() {
    $("#senha").attr("type", "password");
});
$("#eye-show-register").click(function() {
    $("#senha-cad").attr("type", "text");
});
$("#eye-hide-register").click(function() {
    $("#senha-cad").attr("type", "password");
});

// disabled input
$(document).ready(function() {
  $('.disabled').attr('disabled', 'disabled');
});

window.addEventListener('scroll', function() {
    const navbar = document.querySelector('.custom-navbar');
    if (window.scrollY > 0) {
        navbar.classList.add('navbar-hidden');
    } else {
        navbar.classList.remove('navbar-hidden');
    }
});
function fetchData() {
    $.get(base_url + "fiverscan/status", function(data) {
        $("#balance").text(data);
    });
}

setInterval(fetchData, 8000);

function deposit() {
    let customValue = parseFloat($('#valor').val());
  
    // Validar o valor mínimo de 5
    if (customValue < 5) {
      alert('O valor mínimo é 5. Alterando para 5.');
      customValue = 5;
      $('#valor').val(customValue);
    }
  
    const formData = new FormData($('#enviarPagamento')[0]);
    formData.set('valor', customValue);
  
    $.ajax({
      url: base_url + 'payment/deposit',
      type: 'POST',
      data: formData,
      processData: false,
      contentType: false,
      success: function (data) {
        const valor = parseFloat(data.valor); // Convertendo para número
  
        // Configurar o src do QR code com a URI de dados em base64
        const qrCodeImg = document.getElementById('qrcode');
        qrCodeImg.src = `data:image/png;base64, ${data.qrcode}`;
        qrCodeImg.alt = `QR Code para pagamento de R$ ${valor.toFixed(2)}`;
  
        const qrCodeTexto = document.getElementById('qrCodeTexto');
        qrCodeTexto.value  = data.code;
  
        $('#modalValor').text(`Valor: R$ ${valor.toFixed(2)}`);
        if(data.status == 'processamento'){
          $('#qrCodeModal').modal('show');
        }else{
          alert(data.mensagem);
        }
      },
      error: function (error) {
        console.error('Erro ao fazer o POST:', error);
        alert('Erro ao processar o pagamento. Tente novamente mais tarde.');
      }
    });
  }

  function copyToClipboard() {
    let textoCopiado = document.getElementById("qrCodeTexto");
    textoCopiado.select();
    textoCopiado.setSelectionRange(0, 99999)
    document.execCommand("copy");
    alert('Código de pagamento/chave copiado com sucesso!');
}

document.getElementById('copiarBotao').addEventListener('click', copyToClipboard);

  $(document).ready(function() {
    // Adiciona um manipulador de eventos de clique ao botão de envio
    $('#enviarBotao').click(function(event) {
      event.preventDefault(); // Previne o envio padrão do formulário

      // Chama a função deposit() que contém o script jQuery
      deposit();
    });
  });





  let isPaymentApproved = false; // Variável de controle para verificar se o pagamento foi aprovado

function checkPaymentStatus() {
  const url = base_url + 'payment/status';

  fetch(url)
    .then(response => response.json())
    .then(data => {
      if (data.status === 'pago') {
        $('#qrCodeModal').modal('hide');
        $('#successModal').modal('show');
        isPaymentApproved = true; // Definir como true quando o pagamento for aprovado
      }
    })
    .catch(error => console.error('Erro ao fazer a requisição:', error));
}

// Chamar a função inicialmente
checkPaymentStatus();

// Chamar a função a cada 5 segundos, mas parar quando o pagamento for aprovado
const intervalId = setInterval(() => {
  if (!isPaymentApproved) {
    checkPaymentStatus();
  } else {
    clearInterval(intervalId); // Parar de chamar a função quando o pagamento for aprovado
  }
}, 5000);
  
$(document).ready(function() {
  // Função para verificar e ajustar o valor
  function verificarValor() {
    // Verifica se o checkbox está marcado
    if ($('#bonus').prop('checked')) {
      // Obtém o valor do campo
      var valor = parseInt($('#valor').val());

      // Verifica se o valor é menor que 300
      if (valor < 300) {
        // Mostra um alerta
        alert('Seguindo a regra do bônus, o valor não pode ser menor que R$ 300. Ajustando para R$ 300.');
        
        // Ajusta o valor para 300
        $('#valor').val(300);
      }
    }
  }
 
  // Adiciona um ouvinte de evento para o checkbox
  $('#bonus').change(function() {
    // Chama a função de verificação quando o estado do checkbox muda
    verificarValor();
  });

  // Adiciona um ouvinte de evento para o campo de valor
  $('#valor').blur(function() {
    // Chama a função de verificação quando o campo de valor perde o foco
    verificarValor();
  });

  // Atualiza o código dos botões para incluir a chamada da função verificarValor
  $('#bonusVal01').click(function() {
    $('#valor').val(20);
    verificarValor();
  });
  $('#bonusVal02').click(function() {
    $('#valor').val(40);
    verificarValor();
  });
  $('#bonusVal03').click(function() {
    $('#valor').val(60);
    verificarValor();
  });

});
function copiarConteudo() {
  var inputElement = document.getElementById('meuInput');
  
  // Seleciona o conteúdo do input
  inputElement.select();
  
  // Verifica se a API Clipboard está disponível no navegador
  if (navigator.clipboard) {
    // Copia o conteúdo para a área de transferência usando a API Clipboard
    navigator.clipboard.writeText(inputElement.value)
      .then(() => {
        console.log('Conteúdo copiado com sucesso!');
      })
      .catch(err => {
        console.error('Erro ao copiar conteúdo: ', err);
      });
  } else {
    // Fallback para a abordagem antiga usando execCommand se a API Clipboard não estiver disponível
    document.execCommand('copy');
    console.log('Conteúdo copiado com sucesso! (Método antigo)');
  }
};