<?php

class CPA_model extends CI_Model {

    const HISTORICO_ID_CPA = 1001;
    const PAGINA_CREDITO_CPA = 'Crédito CPA';

    /**
     * Insere um registro no histórico.
     *
     * @param array $dados Dados a serem inseridos no histórico.
     * @return bool Retorna verdadeiro se a inserção for bem-sucedida, falso caso contrário.
     */
    public function insertHist($dados) {
        date_default_timezone_set('America/Sao_Paulo');

        $this->db->insert('historico', $dados);
        return true;
    }

    /**
     * Adiciona saldo à conta de um usuário.
     *
     * @param int $usuario_id ID do usuário.
     * @param float $valor_adicionar Valor a ser adicionado ao saldo.
     * @return bool Retorna verdadeiro se a operação for bem-sucedida, falso caso contrário.
     */
    public function adicionar_saldo($usuario_id, $valor_adicionar) {
        $this->db->select('saldo');
        $this->db->where('usuario', $usuario_id);
        $query = $this->db->get('afiliado');

        if ($query->num_rows() > 0) {
            $saldo_atual = $query->row()->saldo;
            $novo_saldo = $saldo_atual + $valor_adicionar;

            $this->db->where('usuario', $usuario_id);
            $this->db->update('afiliado', array('saldo' => $novo_saldo));

            return true;
        } else {
            return false;
        }
    }

    /**
     * Verifica se um usuário possui um afiliado.
     *
     * @param int $id ID do usuário.
     * @return mixed Retorna os dados do usuário afiliado se existir, falso caso contrário.
     */
    public function checkIsHaveDad($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('usuarios')->result();

        if ($query && $query[0]->afiliado) {
            return $query;
        } else {
            return false;
        }
    }

    /**
     * Obtém o ID do pai de um usuário.
     *
     * @param int $id ID do usuário.
     * @return int Retorna o ID do pai.
     */
    public function getDad($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('usuarios')->result();

        $this->db->where('usuario', $query[0]->afiliado);
        $dad = $this->db->get('usuarios')->result();

        return $dad ? $dad[0]->id : 0;
    }

    /**
     * Verifica se um usuário é do tipo afiliado.
     *
     * @param int $id ID do usuário.
     * @return bool Retorna verdadeiro se o usuário for do tipo afiliado, falso caso contrário.
     */
    public function checkIsAfiliado($id) {
        $query = $this->db->get_where('usuarios', array('id' => $id, 'tipo' => 'afiliado'));
        return $query->num_rows() > 0;
    }


    
	public function checkCustomCPA($id) {
		$this->db->where('usuario', $id);
        $query = $this->db->get('afiliado')->result();
        if ($query[0]->cpaLvl1 >= 1) {
            return true;
        } else {
            return false; 
        }
    }
    /**
     * Verifica se um usuário possui CPA personalizado.
     *
     * @param int $id ID do usuário.
     * @return mixed Retorna os dados do afiliado se possuir CPA personalizado, falso caso contrário.
     */
    public function checkAfiliadoCustomCPA($id) {
        $this->db->where('usuario', $id);
        $query = $this->db->get('afiliado')->result();

        return $query && $query[0]->cpaLvl1 ? $query : false;
    }

    /**
     * Obtém as configurações gerais de CPA.
     *
     * @return mixed Retorna as configurações de CPA se existirem, falso caso contrário.
     */
    public function geralCPA() {
        $query = $this->db->get('afiliados_config', array('id' => 0))->result();
        return $query ? $query : false;
    }

    /**
     * Obtém transações pagas de um usuário.
     *
     * @param int $user ID do usuário.
     * @param string $trans ID da transação.
     * @return mixed Retorna as transações pagas se existirem, falso caso contrário.
     */
    public function pegaTrans($user, $trans) {
        $this->db->where(array('transacao_id' => $trans, 'usuario' => $user, 'status' => 'pago'));
        $query = $this->db->get('transacoes')->result();
        return $query ? $query : false;
    }

    /**
     * Processa o CPA para um usuário.
     *
     * @param int $id ID do usuário.
     * @param float $cpa Valor CPA.
     * @return bool Retorna verdadeiro se o processamento for bem-sucedido, falso caso contrário.
     */
    private function processaCPA($id, $cpa) {
        $valor = $cpa;

        $insertHist = array(
            'historico_id' => self::HISTORICO_ID_CPA,
            'credito' => 'R$ ' . number_format($valor, 2),
            'usuario' => $id,
            'pagina' => self::PAGINA_CREDITO_CPA,
            'ip' => $this->input->ip_address(),
            'data_hora' => date('d/m/Y H:i:s'),
        );

        $this->insertHist($insertHist);
        $addsaldo = $this->adicionar_saldo($id, $valor);

        return $addsaldo;
    }


    public function insertCPA($id, $dad) {

        $dados = array('status'   => 'pago',
                       'afiliado' => $dad,
                       'usuario'  => $id);

        $this->db->insert('cpa', $dados);
        return true;
    }
    /**
     * Obtém o nivel do usuário.
     *
     * @param int $id ID do usuário.
     */
    public function obterNivel($id) {
        $this->db->where('id', $id);
        $user = $this->db->get('usuarios')->result();
    
        if (!empty($user)) {
            $this->db->select('afiliado.usuario AS afiliado, usuario.usuario AS usuario, usuario.id AS id_usuario');
            $this->db->select('CASE 
                                WHEN afiliado.usuario IS NULL THEN "lv1" 
                                WHEN EXISTS (SELECT 1 FROM usuarios AS neto WHERE neto.afiliado = usuario.usuario) THEN "lv2" 
                                ELSE "lv2" 
                            END AS nivel', FALSE);
            $this->db->from('usuarios AS usuario');
            $this->db->join('usuarios AS afiliado', 'usuario.afiliado = afiliado.usuario', 'left');
            $this->db->where('afiliado.usuario', $user[0]->usuario);
            $this->db->or_where('usuario.usuario', $user[0]->usuario);
    
            $query = $this->db->get();
            $result = $query->result();
    
            // Verifica se $result não está vazio antes de retornar
            if (!empty($result)) {
                return $result;
            } else {
                // Retorna algum valor padrão ou gera um erro, dependendo do seu caso
                return false;
            }
        } else {
            // Retorna algum valor padrão ou gera um erro, dependendo do seu caso
            return false;
        }
    }


    /**
     * Verifica e processa o CPA para um usuário.
     *
     * @param int $id ID do usuário.
     * @param string $trans ID da transação.
     */
    public function checaCPA($id, $trans) {
        date_default_timezone_set('America/Sao_Paulo');
    
        $afiliado = $this->checkIsAfiliado($id);
        $customCPA = $this->checkAfiliadoCustomCPA($id);
        $trans = $this->pegaTrans($id, $trans);
        $geralCPA = $this->geralCPA();
        $check = $this->checkIsHaveDad($id);
    
        if ($check) {
            $dad = $this->getDad($id);
    
            $this->db->where('usuario', $id);
            $query = $this->db->get('afiliado');
    
            if ($query !== false) {
                $queryResult = $query->result();
    
                $this->db->where([
                    'status'   => 'pago',
                    'afiliado' => $dad,
                    'usuario'  => $id
                ]);
                $cpaExiste = $this->db->get('cpa');
    
                if ($cpaExiste !== false) {
                    $cpaResult = $cpaExiste->result();
    
                    $niveis = $this->obterNivel($dad);
    
                    if($niveis == false){
                    }else{
                        foreach ($niveis as $nvs) {
                            if (!$cpaResult) {
                                if($nvs->nivel == 'lv1'){
                                    if ($queryResult[0]->cpaLvl1 >= 1) {
                                        $this->processaCPA($dad, $queryResult[0]->cpaLvl1);
                                        $this->insertCPA($id, $dad);
                                    } else {
                                        $this->processaCPA($dad, $geralCPA[0]->cpaLvl1);
                                        $this->insertCPA($id, $dad);
                                    }
                                } elseif($nvs->nivel == 'lv2'){
                                    if ($queryResult[0]->cpaLvl2 >= 1) {
                                        $this->processaCPA($nvs->id_usuario, $queryResult[0]->cpaLvl2);
                                        $this->insertCPA($id, $nvs->id_usuario);
                                    } else {
                                        $this->processaCPA($nvs->id_usuario, $geralCPA[0]->cpaLvl2);
                                        $this->insertCPA($id, $nvs->id_usuario);
                                    }
                                } elseif($nvs->nivel == 'lv3'){
                                    if ($queryResult[0]->cpaLvl3 >= 1) {
                                        $this->processaCPA($nvs->id_usuario, $queryResult[0]->cpaLvl3);
                                        $this->insertCPA($id, $nvs->id_usuario);
                                    } else {
                                        $this->processaCPA($nvs->id_usuario, $geralCPA[0]->cpaLvl3);
                                        $this->insertCPA($id, $nvs->id_usuario);
                                    }
                                }
                            }
                        }
                    }
                }
            } 
        }
    }
    
}