<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cassino extends CI_Controller {

	public function index()
	{
		$this->fiverscans->pegarSaldo($this->session->id);
		$data = [
			'nomepagina' => 'Bem vindo!',
			'config' => $this->app->config(),
			'partner' => $this->input->get('ref'), // Obtém o parâmetro GET 'parametro'
			'jogos' => $this->db->get('games')->result(),
			'signup' => $this->app->configFin('signup-bonus-text'),
			'bonus' => $this->app->configFin('deposit-bonus-text'),
			'minSaque' => $this->app->configFin('min-saque'),
			'EnableCashback' => $this->app->configFin('cashback-enable-text'),
		];
	
		$this->session->set_userdata('site_lang',  "portuguese");
		$this->app->AccessLogger();
	
		$views = ['layout/header', 'layout/register', 'layout/modals', 'welcome/cassino', 'layout/footer'];
	
		foreach ($views as $view) {
			$this->load->view("pages/$view", $data);
		}
	}
	
	public function aovivo()
	{
		$this->fiverscans->pegarSaldo($this->session->id);
		$data['nomepagina'] = 'Bem vindo!';
		$data['config'] = $this->app->config();
		$this->session->set_userdata('site_lang',  "portuguese");
		$partner = $this->input->get('ref'); // Obtém o parâmetro GET 'parametro'
        $data['partner'] = $partner;
		$q = "SELECT p.code AS provider, g.game_name, g.banner, g.game_code FROM provedores p RIGHT JOIN games g ON p.code = g.provider WHERE p.type = 'live'";
		$data['jogos'] = $this->db->query($q)->result();
		$data['signup'] = $this->app->configFin('signup-bonus-text');
		$data['bonus'] = $this->app->configFin('deposit-bonus-text');
		$data['minSaque'] = $this->app->configFin('min-saque');
		$data['EnableCashback'] = $this->app->configFin('cashback-enable-text');
		$this->app->AccessLogger();
		$this->load->view('pages/layout/header', $data);
		$this->load->view('pages/layout/register', $data);
		$this->load->view('pages/layout/modals', $data);
		$this->load->view('pages/welcome/cassino', $data);
		$this->load->view('pages/layout/footer', $data);
	}

	public function blackjack()
	{
		$data['nomepagina'] = 'Bem vindo!';
		$data['config'] = $this->app->config();

		$this->session->set_userdata('site_lang',  "portuguese");
		$this->fiverscans->pegarSaldo($this->session->id);

		$partner = $this->input->get('ref'); // Obtém o parâmetro GET 'parametro'
        $data['partner'] = $partner;
		$q = "SELECT p.code AS provider, g.game_name, g.banner, g.game_code FROM provedores p RIGHT JOIN games g ON p.code = g.provider WHERE p.type = 'live' and game_name like '%blackjack%'";
		$data['jogos'] = $this->db->query($q)->result();
		$data['signup'] = $this->app->configFin('signup-bonus-text');
		$data['bonus'] = $this->app->configFin('deposit-bonus-text');
		$data['minSaque'] = $this->app->configFin('min-saque');
		$data['EnableCashback'] = $this->app->configFin('cashback-enable-text');
		$this->app->AccessLogger();
		$this->load->view('pages/layout/header', $data);
		$this->load->view('pages/layout/register', $data);
		$this->load->view('pages/layout/modals', $data);
		$this->load->view('pages/welcome/cassino', $data);
		$this->load->view('pages/layout/footer', $data);
	}
	public function bacara()
	{
		$data['nomepagina'] = 'Bem vindo!';
		$data['config'] = $this->app->config();

		$this->session->set_userdata('site_lang',  "portuguese");
		$this->fiverscans->pegarSaldo($this->session->id);

		$partner = $this->input->get('ref'); // Obtém o parâmetro GET 'parametro'
        $data['partner'] = $partner;

		$q = "SELECT p.code AS provider, g.game_name, g.banner, g.game_code FROM provedores p RIGHT JOIN games g ON p.code = g.provider WHERE p.type = 'live' and game_name like '%baccara%'";
		$data['jogos'] = $this->db->query($q)->result();
		$data['signup'] = $this->app->configFin('signup-bonus-text');
		$data['bonus'] = $this->app->configFin('deposit-bonus-text');
		$data['minSaque'] = $this->app->configFin('min-saque');
		$data['EnableCashback'] = $this->app->configFin('cashback-enable-text');
		$this->app->AccessLogger();
		$this->load->view('pages/layout/header', $data);
		$this->load->view('pages/layout/register', $data);
		$this->load->view('pages/layout/modals', $data);
		$this->load->view('pages/welcome/cassino', $data);
		$this->load->view('pages/layout/footer', $data);
	}


	public function buscar()
	{
		$game = $this->input->post('game');
		$data['nomepagina'] = 'Bem vindo!';
		$data['config'] = $this->app->config();

		$this->session->set_userdata('site_lang',  "portuguese");
		$this->fiverscans->pegarSaldo($this->session->id);

		$partner = $this->input->get('ref'); // Obtém o parâmetro GET 'parametro'
        $data['partner'] = $partner;

		$q = "SELECT p.code AS provider, g.game_name, g.banner, g.game_code FROM provedores p RIGHT JOIN games g ON p.code = g.provider WHERE game_name like '%". $game ."%'";
		
		$data['jogos'] = $this->db->query($q)->result();

		$data['signup'] = $this->app->configFin('signup-bonus-text');
		$data['bonus'] = $this->app->configFin('deposit-bonus-text');
		$data['minSaque'] = $this->app->configFin('min-saque');
		$data['EnableCashback'] = $this->app->configFin('cashback-enable-text');


		$this->app->AccessLogger();

		$this->load->view('pages/layout/header', $data);
		$this->load->view('pages/layout/register', $data);
		$this->load->view('pages/layout/modals', $data);
		$this->load->view('pages/welcome/cassino', $data);
		$this->load->view('pages/layout/footer', $data);
	}

	public function provedor ($provedor) {
		$this->fiverscans->pegarSaldo($this->session->id);

		$data = [
			'nomepagina' => 'Bem vindo!',
			'config' => $this->app->config(),
			'partner' => $this->input->get('ref'), // Obtém o parâmetro GET 'parametro'
			'jogos' => $this->db->get('games')->result(),
			'signup' => $this->app->configFin('signup-bonus-text'),
			'bonus' => $this->app->configFin('deposit-bonus-text'),
			'minSaque' => $this->app->configFin('min-saque'),
			'EnableCashback' => $this->app->configFin('cashback-enable-text'),
			'nome_provedor' => $provedor
		];
		$this->session->set_userdata('site_lang',  "portuguese");
		$this->app->AccessLogger();

		$query = "SELECT * FROM games WHERE provider = '{$provedor}'";
		$data['jogos'] = $this->db->query($query)->result();
	
		$views = ['layout/header', 'layout/register', 'layout/modals', 'welcome/provedor', 'layout/footer'];
	
		foreach ($views as $view) {
			$this->load->view("pages/$view", $data);
		}
	}
}
