<main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
<div class="container mt-5">

        <div class="d-flex align-items-center">
            <h1 class="mb-4 font">Lista de Usuários</h1>    
            
            <a class="btn btn-primary ms-auto me-2" href="<?php echo site_url('usuarios/create'); ?>"><i class="fa-solid fa-user-plus"></i></a>

            <div class="col-md-2">
                <form class="d-flex" action="<?= base_url(); ?>usuarios/buscar" method="post">
                    <input class="form-control me-2" type="search" placeholder="Pesquisar" aria-label="Search" name="busca">
                    <button class="btn btn-outline-primary" type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
                </form>
            </div>
        </div>
        


        <?php if ($this->session->flashdata('msg')): ?>
            <div class="alert alert-<?= $this->session->flashdata('tipo'); ?> font" role="alert">
                <?= $this->session->flashdata('msg'); ?>
            </div>
        <?php endif; ?>
        
        <?php if (empty($users)): ?>
            <div class="card text-center bg-card-black">

                <div class="card-body mt-5 mb-5">
                    
                    <h2 class="font mb-5" >Nenhum registro encontrado.</h2>
                

                
                    <a href="<?php echo site_url('usuarios/create'); ?>" class="btn btn-primary btn-lg">Criar novo usuário</a>
                </div>
            </div>
        <?php else: ?>
          <div class="card bg-card-black">
            <div class="card-body">
                <div class="container">
                


                    <table class="table">
                        <thead>
                            <tr>
                            <th scope="col">#</th>
                            <th scope="col">Nome</th>
                            <th scope="col">E-mail</th>
                            <th scope="col">CPF</th>
                            <th scope="col">Saldo</th>
                            <th scope="col">Tipo</th>
                            <th scope="col"></th>
                            </tr>
                        </thead>
                        <tbody>
                    <?php foreach ($users as $user): ?>  
                        <tr>
                            <th scope="row"><?php echo $user->id; ?></th>
                            <td><?php echo $user->nome; ?></td>
                            <td><?php echo $user->email; ?></td>
                            <td><?php echo $user->cpf; ?></td>
                            <td><?php echo 'R$ ' . number_format($user->saldo, 2); ?></td>
                            <td>
                                    <?php if ($user->tipo === 'usuário') { ?>
                                        <span class="badge rounded-pill text-bg-primary">Usuário</span>
                                    <?php } elseif($user->tipo === 'afiliado') { ?>
                                        <span class="badge rounded-pill text-bg-success">Afiliado</span>
                                    <?php } else { ?>
                                        <span class="badge rounded-pill text-bg-danger"><?php echo $user->tipo; ?></span>
                                    <?php } ?>
                        
                            </td>
                            <td>
                                <a class="btn btn-light" href="<?php echo site_url('usuarios/historico/'.$user->id); ?>" role="button"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-pencil-ruler"><path d="m15 5 4 4"/><path d="M13 7 8.7 2.7a2.41 2.41 0 0 0-3.4 0L2.7 5.3a2.41 2.41 0 0 0 0 3.4L7 13"/><path d="m8 6 2-2"/><path d="m2 22 5.5-1.5L21.17 6.83a2.82 2.82 0 0 0-4-4L3.5 16.5Z"/><path d="m18 16 2-2"/><path d="m17 11 4.3 4.3c.94.94.94 2.46 0 3.4l-2.6 2.6c-.94.94-2.46.94-3.4 0L11 17"/></svg></a>
                                <button type="button" id="<?php echo $user->id; ?>" class="btn btn-danger remove"><i class="fas fa-trash-alt"></i> Apagar</button>       
                            </td>
                        </tr>
                    <?php endforeach; ?>     
                        </tbody>
                    </table>
                </div>
            </div>
            <nav class="mb-3">
                <?php echo $this->pagination->create_links(); ?>
            </nav>
        </div>
        <?php endif; ?>
    </div>
    </div>
</main>
<script type="text/javascript">
            $(".remove").click(function() {

                var id = $(this).attr("id");

                swal({

                        title: "Apagar",
                        text: "Tem certeza que deseja apagar este usuário?",
                        type: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "Sim, apagar!",
                        cancelButtonText: "Não, cancelar!",
                        closeOnConfirm: false,
                        closeOnCancel: false },
                    function (isConfirm) {
                        if (isConfirm) {
                            $.ajax({
                                url: "<?php echo site_url('usuarios/delete/')?>" + id,
                                type: 'DELETE',
                                data: {id: id},
                                success: function (data) {
                                    swal("Apagado!", "O usuário foi apagado com sucesso.", "success");
                                    location.reload();
                                },
                                error: function (data) {
                                    swal("Erro!", "Ocorreu um erro ao apagar o usuário.", "error");
                                }
                            });
                        } else {
                            swal("Cancelado", "O usuário não foi apagado.", "error");
                        }
                    });
            });
</script>