<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Suitpay{
        
            public function __construct()
            {
                $this->CI = &get_instance();
                $this->CI->load->helper('url');
                $this->CI->config->item('base_url');
                $this->CI->load->database();
            }
            private function enviarRequest($url, $header, $data=null) {
                $ch = curl_init();
        
            
                $data_json = json_encode($data);
        
                // Configurando as opções do cURL
                curl_setopt($ch, CURLOPT_URL, $url);
                if(!$data == null){
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_json);
                }
                curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
                // Executando a requisição e obtendo a resposta
                $response = curl_exec($ch);
        
                // Fechando a conexão cURL
                curl_close($ch);
        
                return $response;
            }
            private function requestToken($url, $header, $data) {
                $ch = curl_init();
        
                // Configurando as opções do cURL
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        
                // Executando a requisição e obtendo a resposta
                $response = curl_exec($ch);
        
                // Fechando a conexão cURL
                curl_close($ch);
        
                return $response;
            }

            public function criarSaque($id,$valor,$tipo,$key){
                date_default_timezone_set('America/Sao_Paulo');
                
                if($tipo == 'CPF'){
                    $suitType = 'document';
                }
                if($tipo == 'TELEFONE'){
                    $suitType = 'phoneNumber';
                }
                if($tipo == 'EMAIL'){
                    $suitType = 'email';
                }
                if($tipo == 'CHAVE_ALEATORIA'){
                    $suitType = 'randomKey';
                }
        
        
                $this->CI->db->where('id',0);	
                $suitpayData = $this->CI->db->get('suitpay')->result();
        
        
                $url = $suitpayData[0]->url.'/api/v1/gateway/pix-payment';
        
        
                $data = array(
                    "key" => $key,
                    "typeKey" =>  $suitType,
                    "value" => $valor,
                    "callbackUrl" => "https://webhook.com/"
                );
        
                $header = array(
                    'ci: '.$suitpayData[0]->client_id,
                    'cs: '.$suitpayData[0]->client_secret,
                    'Content-Type: application/json',
                );
        
        
                $response = $this->enviarRequest($url, $header, $data);
                
                $dados = json_decode($response, true);
        
               
                if (isset($dados['error']) && $dados['error']) {
    
                    echo "Falha na api";
                    
                } else {
                
                    if (isset($dados['idTransaction']) && $dados['idTransaction']) {
                
                        $insert = array(
                            'transacao_id' => $dados['idTransaction'],
                            'usuario' => $id,
                            'valor' => $valor,
                            'tipo' => 'saque',
                            'data_hora' => date('Y-m-d H:i:s'),
                            'status' => 'pago'
                        );
                
                        $this->CI->db->insert('transacoes', $insert);
                    }
                }   
            }
}